;This program is the exercise for Chapter 11 Analog to Digital Conversion.  A 10K ohm
;variable resistor is connected between 5-volts (the reference voltage) and ground.  The
;potentiometer wiper is connected to PORTC,0 which is configured as an ADC.  The LCD
;display is connected to PORTA,5.


	list      p=16F676       ; list directive to define processor
	#include <p16f676.inc>    ; processor specific variable definitions



	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _HS_OSC & _MCLRE_OFF & _CPD_OFF
; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80

;*******************************************************************************
;LCD defines
;********************************************************************************
#define LCD			0x05			;pin RA5 connected to LCD data line
#define	LED1		0x05			;pin RC5 connected to LED1
#define LED2		0x04			;pin RC4 connected to LED2
#define	LCD_BKSPC	0x08			;move cursor left
#define	LCD_RT		0x09			;move cursor right
#define	LCD_LF		0x0A			;move cursor down 1 line
#define LCD_CLS		0x0C			;clear LCD (allow 5 ms delay to complete)
#define	LCD_CR		0x0D			;move position 0 of next line
#define	LCD_BL_ON	0x11			;backlight on
#define	LCD_BL_OFF	0x12			;backlight off
#define LCD_OFF		0x15			;LCD off
#define LCD_ON1		0x16			;LCD on, cursor off, blink off
#define LCD_ON2		0x17			;LCD on, cursor off, blink on
#define LCD_ON3		0x18			;LCD on, cursor on, blink off
#define	LCD_ON4		0x19			;LCD on, cursor of, blink on
#define LCD_LINE0	0x80			;move to line 1, column 0, add position to 0x80
#define LCD_LINE1	0x94			;move to line 2, column 0, add position to 0x94
#define LCD_LINE2	0xA8			;move to line 3, column 0, add position to 0xA8
#define LCD_LINE3	0xBC			;move to line 4, column 0, add position to 0xBC
;end LCD defines
;******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	count			;used in delay routines
	tempa
	bitcounter		;used in LCD display routine
	byte_to_send
	countBCD		;used by Binary to BCD Converter
	temp
	h_byte
	l_byte
	r0
	r1
	r2
	endc
;******************************************************************************

;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	;goto interupt_service
	return			; interrupt trap - returns without re-enabling
;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL	Bank1
	call    0x3FF      ; retrieve factory calibration value
	movwf	OSCCAL

	BANKSEL	Bank0		;select bank0
	clrf	PORTA		;clear port bus
	clrf	PORTC		;clear port bus
	movlw	b'00000111'	;non inverted, comp with output
	movwf	CMCON		;/
	movlw	b'00000000'	;globals, peripherals, ra2 int, clear INTF
	movwf	INTCON
	movlw	b'10010001'	;right justified,Vdd ref RC0 has ADC, ADC Stop, ADC on
	movwf	ADCON0
	BANKSEL	Bank1		;use Bank1
	movlw	b'00000000'	;load w reg  
	movwf	OPTION_REG	;put w reg into option register
	movlw	b'00010000'	;Fosc/8
	movwf	ADCON1
	movlw	b'00000000'	;load w reg with PORTA I/O 
	movwf	TRISA		;program PORTA
	movlw	b'00000001'	;load w reg with PORTC I/O (RC0 input)
	movwf	TRISC		;program PORTC
	movlw	b'00010000'	;RC0 analog, all other digital
	movwf	ANSEL		
	BANKSEL	Bank0		;back to bank0
;end pic initialization
	
;*****************************************************************************
;Initialize the LCD display
;*****************************************************************************
	bsf		PORTA,LCD			;set to high for resting state
	call	wait1sec		;to allow LCD to inialize
	movlw	LCD_CLS
	call	LCDOutput
	call	delay5mS		;to allow LCD to complete clear

;end LCD initialization
;****************************************************************************


;*****************************************************************************
;main program

	movlw	LCD_LINE0			;sends text to LCD display
	call	LCDOutput
	movlw	"R"
	call	LCDOutput
	movlw	"C"
	call	LCDOutput
	movlw	"0"
	call 	LCDOutput

main
	movlw	LCD_LINE0+4			;moves LDC display location to line 0 position 4
	call	LCDOutput
	bsf		ADCON0,GO			;set GO bit to begin ADC conversion
wait_ADC
	btfsc	ADCON0,NOT_DONE			;check if ADC complete (cleared bit)
	goto	wait_ADC			;if not, loop and wait until clear
	
	BANKSEL	Bank1				;switch to bank 1 to access ADC low byte
	movfw	ADRESL
	BANKSEL Bank0				;go back to bank 0 to aaccess l_byte variable
	movwf	l_byte
	movfw	ADRESH				;get ADC high byte
	movwf	h_byte				;put in h_byte
	
	
	call	display_DEC			;this subroutine converts the 10-bit ADC value into
								;a 4 digit decimal value, then converts each digit
								;into the equivalent ASCII so that it can be displayed
								;on the LCD.
	
	goto	main				;go back for next reading of the ADC

					
;*****************************************************************************
;
;Display 10-bit decimal number (from ADC)
;put high byte in h_byte
;put low byte in l_byte
;call display_DEC
;
;*****************************************************************************
display_DEC
	call	b2_BCD
	swapf	r1,w
	andlw	b'00001111'
	addlw	.48
	call	LCDOutput
	movfw	r1
	andlw	b'00001111'
	addlw	.48
	call	LCDOutput
	swapf	r2,w
	andlw	b'00001111'
	addlw	.48
	call	LCDOutput
	movfw	r2
	andlw	b'00001111'
	addlw	.48
	call	LCDOutput
	return
;end display_DEC
;*******************************************************************************

;*****************************************************************************
;
;LCD Output
;put the desired value into the w register and call LCDOutput
;
;*****************************************************************************
LCDOutput
	movwf	byte_to_send
	movlw .8
	movwf bitcounter	;set up to send 8 bits
	bcf		PORTA,LCD			;send start bit
	call	bitdelay
nextbit
	rrf		byte_to_send,f	;sending lsb first
	btfss	STATUS,C
	bcf		PORTA,LCD
	btfsc	STATUS,C
	bsf		PORTA,LCD
	call	bitdelay
	decfsz	bitcounter,f
	goto	nextbit
	bsf		PORTA,LCD		;set to high for resting state
	call	delay5mS
	return
;end LCDOutput
;*******************************************************************************

;******************************************************************************
;
;Binary to BCD converter
;Put binary value to be converted into h_byte and l_byte
;then call b2_BCD.  Decimal converstion is returned in r0, r1, and r2
;with MSB in lower nibble of r0.
;
;******************************************************************************
b2_BCD
	bcf		STATUS,C
	movlw	.16
	movwf	countBCD
	clrf	r0
	clrf	r1
	clrf	r2
loop16
	rlf		l_byte,f
	rlf		h_byte,f
	rlf		r2,f
	rlf		r1,f
	rlf		r0,f
	
	decfsz	countBCD,f
	goto	adjDEC
	retlw	0

adjDEC
	movlw	r2
	movwf	FSR
	call	adjBCD
	
	movlw	r1
	movwf	FSR
	call	adjBCD

	movlw	r0
	movwf	FSR
	call	adjBCD

	goto	loop16

adjBCD
	movlw	3
	addwf	0,w
	movwf	temp
	btfsc	temp,3
	movwf	0
	movlw	30
	addwf	0,w
	movwf	temp
	btfsc	temp,7
	movwf	0
	retlw	0
;end Binary to BCD Converter
;******************************************************************************	



;******************************************************************************
;Delay Routines
;******************************************************************************
;more delay options than needed, this is standard delay code I use in other programs
wait5sec
		call	wait1sec
		call	wait1sec
		call	wait1sec
		call	wait1sec		;1 seconds plus the one to follow
		

wait1sec
		call	wait300mS
		call	wait300mS
		call	wait300mS
		goto	wait100mS
wait300mS
        call    delay50mS
wait250mS
        call    delay50mS
        call    delay50mS
        call    delay50mS
wait100mS
        call    delay50mS
wait50mS
        call    delay50mS
		return
;delay1ms, is a very accurate 1mS delay for a 4Mhz clock.
delay1mS
        movlw   .198
        movwf   count
        nop
        goto    $+1
        goto    $+1
dly1mS        
        goto    $+1
        decfsz  count, F
        goto    dly1mS
        return
;delay5mS uses delay1mS to get a very accurate 5 mS delay
delay5mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        movlw   .4
        movwf   count
tweek5mS
        decfsz  count, F
        goto    tweek5mS
        return
;delay50mS uses delay1mS to get a very accurate 50mS delay
delay50mS
        movlw   .50
        movwf   tempa
dly50mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly50mS
        movlw   .14
        movwf   count
tweek50mS
        decfsz  count, F
        goto    tweek50mS
        return
;delay200mS uses delay1mS to get a very accurate 200mS delay.
delay200mS
        movlw   .200
        movwf   tempa
dly200mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly200mS
        movlw   .64
        movwf   count
tweek200mS
        decfsz  count, F
        goto    tweek200mS
        return

bitdelay

		movlw	.30				;this number works if the user uses the calbrated
								;value for the internal clock. This routine, including
								;the goto and nop statements below allow the user to develop
								;an anticipated delay of 100uS for the bits at 9600 Baud.
								;This delay can be verified by using the stop watch function
								;of MPLab Simulator 
		movwf	count
		goto    $+1				;these goto statements allow you tweek the time of the
		goto	$+1				;delay.  Goto statements like this take 2 clock cycles
		nop						;while the nop statement takes 1 clock cycle to complete


bit
		decfsz	count, f
		goto	bit
		return
;end delay rountines



	end
